#!/bin/bash


if [ "$1" == "--schedule" ]; then
    echo "bash $0 > /dev/null 2>&1" | at now + 30 minute
    echo "Task scheduled to run in 1 minute via 'at'"
    exit 0
fi

NUM_PROCESS=16
# DEVICE_IDS="[4, 4, 5, 5, 6, 6, 7, 7]"
DEVICE_IDS="[0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7]"
# DEVICE_IDS="[0, 1, 2, 3, 4, 5]"
# DEVICE_IDS="[4]"
# DEVICE_IDS="[1]"

SCRIPT_PATH="evaluate_memory_vs_reasoning_mp.py"
MODEL_PATH="/Agent_ScanKit/models/GUI-Owl-7B"
MODEL_NAME="GUI-Owl-7B"
PROBING_METHOD="text_mask" # [sentence_level, token_level]
DATASET_TYPE="setence_level"
DATASET_PATH="/Agent_ScanKit/datasets/json/${PROBING_METHOD}/${DATASET_TYPE}/${MODEL_NAME}.json"
RESULT_PATH="/Agent_ScanKit/results/${PROBING_METHOD}/${DATASET_TYPE}/${MODEL_NAME}.json"
LOG_DIR="/Agent_ScanKit/logs/evaluation"
THOUGHT="false"

PID=$$
mkdir -p "$LOG_DIR"
LOG_PATH="$LOG_DIR/${PROBING_METHOD}/${DATASET_TYPE}/${MODEL_NAME}.log"

echo "Process started with PID: $PID" > "$LOG_PATH"

nohup python "$SCRIPT_PATH" \
    --model_path "$MODEL_PATH" \
    --model_name "$MODEL_NAME" \
    --dataset_type "$DATASET_TYPE" \
    --dataset_path "$DATASET_PATH" \
    --result_path "$RESULT_PATH" \
    --num_process "$NUM_PROCESS" \
    --deviceIds "$DEVICE_IDS" \
    --thought "$THOUGHT" \
    --probing_method "$PROBING_METHOD" \
    > "$LOG_PATH" 2>&1 &

echo "Task started. Logs saved to: $LOG_PATH"
